<?php

namespace Daylight\Core\Modules\MenuBuilder\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOneThrough;
use Staudenmeir\LaravelAdjacencyList\Eloquent\HasRecursiveRelationships;

class MenuItem extends Model
{
    use HasRecursiveRelationships;

    protected $guarded = [];

    public function translation(): BelongsTo
    {
        return $this->belongsTo(MenuTranslation::class);
    }

    public function menu(): HasOneThrough
    {
        return $this->hasOneThrough(
            related: Menu::class,
            through: MenuTranslation::class,
            firstKey: 'menu_id',
            secondKey: 'id',
            localKey: 'menu_id',
            secondLocalKey: 'id'
        );
    }
}
