<?php

namespace Daylight\Core\Modules\PageBuilder\Entities;

use Illuminate\Support\Collection;

abstract class Component
{
    public string $type;

    abstract public function name(): string;

    abstract public function fields(): Collection;

    public function availableFor(): Collection
    {
        return collect();
    }

    public function disabledFor(): Collection
    {
        return collect();
    }

    public function type(): string
    {
        return $this->type;
    }

    public static function getInstance(): static
    {
        return new static;
    }

    public function toArray(): array
    {
        return [
            'name' => $this->name(),
            'type' => $this->type(),
            'fields' => $this->fields(),
        ];
    }
}
