<?php

namespace Daylight\Core\Modules\PageBuilder\Entities;

class Field
{
    public array $options = [];

    public array $items = [];

    public int $amountOfFiles;

    public string $relatedType;

    public function __construct(
        public string $type,
        public string $name,
        public string $label,
    ) {
        //
    }

    public function required(): self
    {
        $this->options['required'] = true;

        return $this;
    }

    public function withOptions(array $options = []): self
    {
        $this->options = $options;

        return $this;
    }

    public function withItems(array $items = []): self
    {
        $this->items = $items;

        return $this;
    }

    public function setRelatedType(string $relatedType): self
    {
        $this->relatedType = $relatedType;

        return $this;
    }

    public function singleFile(): self
    {
        $this->amountOfFiles = 1;

        return $this;
    }

    public static function make(string $type, string $name, string $label): self
    {
        return new self($type, $name, $label);
    }

    public static function text(string $name, string $label): self
    {
        return new self('text', $name, $label);
    }

    public static function select(string $name, string $label, array $options): self
    {
        return (new self('select', $name, $label))
            ->withOptions($options);
    }

    public static function button(string $name, string $label): self
    {
        return new self('button', $name, $label);
    }

    public static function repeater(string $name, string $label, array $fields): self
    {
        return (new self('repeater', $name, $label))
            ->withItems($fields);
    }

    public static function wysiwyg(string $name, string $label): self
    {
        return new self('wysiwyg', $name, $label);
    }

    public static function media(string $name, string $label): self
    {
        return new self('media', $name, $label);
    }

    public static function related(string $name, string $label, string $type, array $items): self
    {
        return (new self('related', $name, $label))
            ->setRelatedType($type)
            ->withItems($items);
    }
}
