const formatFileSize = (bytes) => {
    if (!+bytes) return '0 Bytes'

    const k = 1024
    const sizes = ['Bytes', 'Kb', 'Mb', 'Gb', 'Tb']

    const i = Math.floor(Math.log(bytes) / Math.log(k))

    return `${parseFloat((bytes / Math.pow(k, i)).toFixed())} ${sizes[i]}`
}

const formatDate = (date) => {
    return new Date(date).toLocaleDateString('en-NL', {
        year: 'numeric',
        month: 'numeric',
        day: 'numeric',
        hour: 'numeric',
        minute: 'numeric'
    })
}

const imageUrl = (file, size = 'raw') => {
    let handle = file.handle.replace(window.daylight.cdnDirectory + '/', '');

    return `https://upcdn.io/kW15bGJ/${size}${window.daylight.cdnDirectory}${handle}`;

    // return `${window.daylight.cdnUrl}/${size}/${handle}`;
}

export { formatFileSize, formatDate, imageUrl }
