@props([
    'items' => []
])

<nav class="flex flex-1 flex-col pt-2" aria-label="Sidebar">
    <ul role="list" class="-mx-2 space-y-1">
        @foreach($items as $item)
            @if($item->getType() === 'divider')
                <li class="pt-4 pb-2">
                    <div class="border-t" aria-hidden="true"></div>
                    <p class="mt-4 ml-3 uppercase text-xs leading-loose text-gray-600">{{ $item->label }}</p>
                </li>
            @else
                <li>
                    <a
                        href="{{ $item->getUrl() }}"
                        class="{{ $item->isActive() ? 'bg-gray-100 text-sky-600' : 'text-gray-700 hover:text-sky-600 hover:bg-gray-100' }} group flex gap-x-3 rounded-md p-2 pl-3 text-sm font-semibold leading-6">
                        {{ $item->label }}
                    </a>
                </li>
            @endif
        @endforeach
    </ul>
</nav>
