<div
    x-data="{
        showAutocomplete: @entangle('showAutocomplete'),
        results: @entangle('results'),
    }"
>
    @if($errors->has('sku'))
        <div class="mb-2 text-xs text-red-500">
            {{ $errors->first('sku') }}
        </div>
    @endif

    <div class="relative">
        <x-daylight.input.text
            name="sku"
            id="sku"
            wire:model.live.debounce="sku"
            @click.prevent="showAutocomplete = results.length > 0"
        />

        @if($selectedVariant)
            <div class="flex w-full truncate whitespace-nowrap mt-4">
                <div class="w-12 flex-0 min-w-12">
                    @if(!$selectedVariant['image'])
                    <div class="w-10 h-10 flex items-center justify-center text-gray-500 rounded border mr-1 bg-gray-100">
                        <svg class="w-4 h-4" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" d="m2.25 15.75 5.159-5.159a2.25 2.25 0 0 1 3.182 0l5.159 5.159m-1.5-1.5 1.409-1.409a2.25 2.25 0 0 1 3.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 0 0 1.5-1.5V6a1.5 1.5 0 0 0-1.5-1.5H3.75A1.5 1.5 0 0 0 2.25 6v12a1.5 1.5 0 0 0 1.5 1.5Zm10.5-11.25h.008v.008h-.008V8.25Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z"></path>
                        </svg>
                    </div>
                    @else
                    <img src="{{ $selectedVariant['image'] }}" alt="{{ $selectedVariant['title'] }}" class="object-cover w-10 h-10 rounded border mr-1">
                    @endif
                </div>
                <div class="flex-0 truncate">
                    <p class="text-sm">{{ $selectedVariant['sku'] }}</p>
                    <p class="text-xs opacity-50 truncate">{{ $selectedVariant['title'] }}</p>
                </div>
            </div>
        @endif

        <div
            x-show="showAutocomplete"
            @click.outside="showAutocomplete = false"
            class="absolute top-10 border bg-white z-50 h-64 rounded w-[300px] overflow-scroll"
        >
            <ul>
                @foreach($results as $result)
                    <li wire:key="{{ $result['sku'] }}">
                        <a href="#" wire:click.prevent="selectVariant('{{ $result['sku'] }}')"
                           class="flex w-full p-3 hover:bg-gray-100 truncate whitespace-nowrap">
                            <div class="w-12 flex-0 min-w-12">
                                @if(!$result['image'])
                                    <div
                                        class="w-10 h-10 flex items-center justify-center text-gray-500 rounded border mr-1 bg-gray-100">
                                        <svg class="w-4 h-4" data-slot="icon" fill="none" stroke-width="1.5"
                                             stroke="currentColor" viewBox="0 0 24 24"
                                             xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                  d="m2.25 15.75 5.159-5.159a2.25 2.25 0 0 1 3.182 0l5.159 5.159m-1.5-1.5 1.409-1.409a2.25 2.25 0 0 1 3.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 0 0 1.5-1.5V6a1.5 1.5 0 0 0-1.5-1.5H3.75A1.5 1.5 0 0 0 2.25 6v12a1.5 1.5 0 0 0 1.5 1.5Zm10.5-11.25h.008v.008h-.008V8.25Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z"></path>
                                        </svg>
                                    </div>
                                @else
                                    <img src="{{ $result['image'] }}" :alt="{{ $result['title'] }}" class="object-cover w-10 h-10 rounded border mr-1">
                                @endif
                            </div>
                            <div class="flex-0 truncate">
                                <p class="text-sm">{{ $result['sku'] }}</p>
                                <p class="text-xs opacity-50 truncate">{{ $result['title'] }}</p>
                            </div>
                        </a>
                    </li>
                @endforeach
            </ul>
        </div>
    </div>
</div>
