<?php

namespace Daylight\Core\Livewire\Settings;

use Daylight\Core\Livewire\Tables\BaseTable;
use Daylight\Core\Livewire\Tables\Concerns\WithSearch;
use Daylight\Core\Models\Country;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\View\View;

class CountryTable extends BaseTable
{
    use WithSearch;

    protected function getBaseQuery(): Builder
    {
        return Country::query();
    }

    protected function applySearch(Builder $query, ?string $searchQuery): Builder
    {
        return $query->when($searchQuery, function ($query, $searchQuery) {
            $query->where('code', 'like', "%{$searchQuery}%");
        });
    }

    public function render(): View
    {
        return view('daylight::livewire.settings.country-table');
    }
}
