<?php

namespace Daylight\Core\Livewire\Store;

use Daylight\Core\Livewire\Tables\BaseTable;
use Daylight\Core\Livewire\Tables\Concerns\WithSearch;
use Daylight\Core\Models\Order;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\View\View;

class OrderTable extends BaseTable
{
    use WithSearch;

    protected function getBaseQuery(): Builder
    {
        return Order::query()->latest();
    }

    public function getSearchQueryArgument(): string
    {
        return 'orderSearchQuery';
    }

    protected function applySearch(Builder $query, ?string $searchQuery): Builder
    {
        return $query->when($searchQuery, function ($query, $searchQuery) {
            $query->where('number', 'like', "%{$searchQuery}%");
        });
    }

    public function render(): View
    {
        return view('daylight::livewire.store.order-table');
    }
}
