<?php

namespace Daylight\Core\Livewire\Store;

use Daylight\Core\Livewire\Tables\BaseTable;
use Daylight\Core\Livewire\Tables\Concerns\WithSearch;
use Daylight\Core\Models\Product;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\View\View;

class ProductTable extends BaseTable
{
    use WithSearch;

    protected function getBaseQuery(): Builder
    {
        return Product::query()->latest();
    }

    protected function applySearch(Builder $query, ?string $searchQuery): Builder
    {
        return $query->when($searchQuery, function ($query, $searchQuery) {
            $query
                ->whereHas('translations', function ($query) use ($searchQuery) {
                    $query->where('name', 'like', "%{$searchQuery}%");
                })
                ->orWhereHas('variants', function ($query) use ($searchQuery) {
                    $query->where('sku', 'like', "%{$searchQuery}%");
                });
        });
    }

    public function render(): View
    {
        return view('daylight::livewire.store.product-table');
    }
}
