<?php

namespace Daylight\Core\Models;

use Daylight\Core\Models\Translations\PageTranslation;
use Daylight\Core\Modules\Multilingualism\Contracts\HasTranslations;
use Daylight\Core\Modules\Multilingualism\Models\Concerns\InteractsWithTranslations;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Page extends Model implements HasTranslations
{
    use InteractsWithTranslations;

    protected $guarded = [];

    public function translatedFields(): array
    {
        return ['name', 'slug', 'meta_title', 'meta_description', 'robots'];
    }

    public function translations(): HasMany
    {
        return $this->hasMany(PageTranslation::class);
    }

    public function defaultTranslation(): HasOne
    {
        return $this
            ->hasOne(PageTranslation::class)
            ->where('locale', config('multilingualism.default_locale'));
    }
}
