<?php

namespace Daylight\Core\Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class RoleSeeder extends Seeder
{
    public function run(): void
    {
        $systemAdministrator = Role::create([
            'name' => 'System Administrator',
            'guard_name' => 'web',
        ]);

        $administrator = Role::create([
            'name' => 'Administrator',
            'guard_name' => 'web',
        ]);

        $storeManager = Role::create([
            'name' => 'Store Manager',
            'guard_name' => 'web',
        ]);

        $contentManager = Role::create([
            'name' => 'Content Manager',
            'guard_name' => 'web',
        ]);

        $relationManager = Role::create([
            'name' => 'Relation Manager',
            'guard_name' => 'web',
        ]);

        $systemAdministrator->permissions()->createMany([
            ['name' => 'view:administration', 'guard_name' => 'web'],

            ['name' => 'create:menus', 'guard_name' => 'web'],
            ['name' => 'read:menus', 'guard_name' => 'web'],
            ['name' => 'update:menus', 'guard_name' => 'web'],
            ['name' => 'delete:menus', 'guard_name' => 'web'],

            ['name' => 'create:pages', 'guard_name' => 'web'],
            ['name' => 'read:pages', 'guard_name' => 'web'],
            ['name' => 'update:pages', 'guard_name' => 'web'],
            ['name' => 'delete:pages', 'guard_name' => 'web'],

            ['name' => 'create:media', 'guard_name' => 'web'],
            ['name' => 'read:media', 'guard_name' => 'web'],
            ['name' => 'update:media', 'guard_name' => 'web'],
            ['name' => 'delete:media', 'guard_name' => 'web'],

            ['name' => 'create:products', 'guard_name' => 'web'],
            ['name' => 'read:products', 'guard_name' => 'web'],
            ['name' => 'update:products', 'guard_name' => 'web'],
            ['name' => 'delete:products', 'guard_name' => 'web'],

            ['name' => 'create:variants', 'guard_name' => 'web'],
            ['name' => 'read:variants', 'guard_name' => 'web'],
            ['name' => 'update:variants', 'guard_name' => 'web'],
            ['name' => 'delete:variants', 'guard_name' => 'web'],

            ['name' => 'create:orders', 'guard_name' => 'web'],
            ['name' => 'read:orders', 'guard_name' => 'web'],
            ['name' => 'update:orders', 'guard_name' => 'web'],
            ['name' => 'delete:orders', 'guard_name' => 'web'],

            ['name' => 'create:customers', 'guard_name' => 'web'],
            ['name' => 'read:customers', 'guard_name' => 'web'],
            ['name' => 'update:customers', 'guard_name' => 'web'],
            ['name' => 'delete:customers', 'guard_name' => 'web'],

            ['name' => 'create:customer-groups', 'guard_name' => 'web'],
            ['name' => 'read:customer-groups', 'guard_name' => 'web'],
            ['name' => 'update:customer-groups', 'guard_name' => 'web'],
            ['name' => 'delete:customer-groups', 'guard_name' => 'web'],

            ['name' => 'create:brands', 'guard_name' => 'web'],
            ['name' => 'read:brands', 'guard_name' => 'web'],
            ['name' => 'update:brands', 'guard_name' => 'web'],
            ['name' => 'delete:brands', 'guard_name' => 'web'],

            ['name' => 'create:categories', 'guard_name' => 'web'],
            ['name' => 'read:categories', 'guard_name' => 'web'],
            ['name' => 'update:categories', 'guard_name' => 'web'],
            ['name' => 'delete:categories', 'guard_name' => 'web'],

            ['name' => 'create:attributes', 'guard_name' => 'web'],
            ['name' => 'read:attributes', 'guard_name' => 'web'],
            ['name' => 'update:attributes', 'guard_name' => 'web'],
            ['name' => 'delete:attributes', 'guard_name' => 'web'],

            ['name' => 'create:labels', 'guard_name' => 'web'],
            ['name' => 'read:labels', 'guard_name' => 'web'],
            ['name' => 'update:labels', 'guard_name' => 'web'],
            ['name' => 'delete:labels', 'guard_name' => 'web'],

            ['name' => 'create:users', 'guard_name' => 'web'],
            ['name' => 'read:users', 'guard_name' => 'web'],
            ['name' => 'update:users', 'guard_name' => 'web'],
            ['name' => 'delete:users', 'guard_name' => 'web'],
            ['name' => 'impersonate:users', 'guard_name' => 'web'],

            ['name' => 'read:settings', 'guard_name' => 'web'],
            ['name' => 'update:settings', 'guard_name' => 'web'],

            ['name' => 'read:advanced-settings', 'guard_name' => 'web'],
            ['name' => 'update:advanced-settings', 'guard_name' => 'web'],
        ]);

        $administrator->syncPermissions($systemAdministrator->permissions);

        // Remove advanced setting permissions from Administrator
        $administrator->revokePermissionTo([
            'create:customers',
            'update:customers',
            'delete:customers',

            'create:orders',
            'update:orders',
            'delete:orders',

            'create:products',
            'update:products',
            'delete:products',

            'create:variants',
            'delete:variants',

            'read:advanced-settings',
            'update:advanced-settings',
        ]);

        $systemAdministrator->revokePermissionTo([
            'create:customers',
            'update:customers',
            'delete:customers',

            'create:orders',
            'update:orders',
            'delete:orders',

            'create:variants',
            'delete:variants',

            //            'create:products',
            //            'update:products',
            //            'delete:products',
        ]);

        $storeManager->syncPermissions([
            'view:administration',

            'create:media',
            'read:media',
            'update:media',
            'delete:media',

            'create:products',
            'read:products',
            'update:products',
            'delete:products',

            'create:variants',
            'read:variants',
            'update:variants',
            'delete:variants',

            'create:labels',
            'read:labels',
            'update:labels',
            'delete:labels',

            'create:attributes',
            'read:attributes',
            'update:attributes',
            'delete:attributes',

            'create:categories',
            'read:categories',
            'update:categories',
            'delete:categories',
        ]);

        $contentManager->syncPermissions([
            'view:administration',

            'create:media',
            'read:media',
            'update:media',
            'delete:media',

            'create:pages',
            'read:pages',
            'update:pages',
            'delete:pages',

            'create:menus',
            'read:menus',
            'update:menus',
            'delete:menus',
        ]);

        $relationManager->syncPermissions([
            'view:administration',

            'create:customers',
            'read:customers',
            'update:customers',
            'delete:customers',

            'create:customer-groups',
            'read:customer-groups',
            'update:customer-groups',
            'delete:customer-groups',

            'create:orders',
            'read:orders',
            'update:orders',
            'delete:orders',

            'create:users',
            'read:users',
            'update:users',
            'delete:users',
        ]);

    }
}
