@extends('daylight::layouts.app')

@section('title', __('Create new menu'))

@section('content')
    <x-daylight::page-header :title="__('Create new menu')"/>
    <x-daylight::session-messages />

    <form method="post" action="{{ route('daylight.content.menus.store') }}">
        @csrf

        <input type="hidden" name="locale" value="{{ request()->get('locale', 'en') }}">

        <x-daylight::input.group
            :label="__('Name')"
            :error="$errors->first('name')"
            :helpText="__('This is a general name which is the same for every locale.')"
            for="name"
        >
            <x-daylight::input.text
                name="name"
                id="name"
                value="{{ old('name') }}"
            />
        </x-daylight::input.group>

        <p class="text-sm my-4 text-gray-500">{{ __('Items can be added after creating the menu.') }}</p>

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.content.menus.index') }}" element="a">
                {{ __('Cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('Save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
