@php
    use Illuminate\Support\Facades\Vite;
@endphp

        <!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="@yield('htmlClass')">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title') - {{ config('app.name') }}</title>

    @yield('head')

    @daylightStyles
    @livewireStyles
</head>

<body class="@yield('bodyClass')">

<div x-data="{ offcanvasMenuOpen: false }">
    <div class="relative z-50 lg:hidden" role="dialog" aria-modal="true" x-show="offcanvasMenuOpen" x-cloak>
        <div appear
             x-show="offcanvasMenuOpen"
             x-transition:enter="transition-opacity ease-linear duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition-opacity ease-linear duration-300"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             class="fixed inset-0 bg-gray-900/80" aria-hidden="true"></div>

        <div class="fixed inset-0 flex">
            <div
                    x-show="offcanvasMenuOpen"
                    x-transition:enter="transition ease-in-out duration-300 transform"
                    x-transition:enter-start="-translate-x-full"
                    x-transition:enter-end="translate-x-0"
                    x-transition:leave="transition ease-in-out duration-300 transform"
                    x-transition:leave-start="translate-x-0"
                    x-transition:leave-end="-translate-x-full"
                    class="relative mr-16 flex w-full max-w-xs flex-1">

                <div
                        x-show="offcanvasMenuOpen"
                        x-transition:enter="ease-in-out duration-300"
                        x-transition:enter-start="opacity-0"
                        x-transition:enter-end="opacity-100"
                        x-transition:leave="ease-in-out duration-300"
                        x-transition:leave-start="opacity-100"
                        class="absolute left-full top-0 flex w-16 justify-center pt-5">
                    <button type="button" class="-m-2.5 p-2.5" @click.prevent="offcanvasMenuOpen = false">
                        <span class="sr-only">Close sidebar</span>
                        <svg class="h-6 w-6 text-white" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                             stroke="currentColor" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>

                <div class="flex grow flex-col gap-y-5 overflow-y-auto bg-gray-900 px-6 pb-2 ring-1 ring-white/10">
                    <nav class="flex flex-1 flex-col mt-4">
                        <ul role="list" class="-mx-2 flex-1 space-y-1">
                            @foreach($navigationItems as $item)
                                @if($item->getType() === 'item')
                                    <li>
                                        <a href="{{ $item->getUrl() }}"
                                           class="{{ $item->isActive() ? 'bg-gray-800 text-white' : 'text-gray-400 hover:text-white hover:bg-gray-800' }} group flex gap-x-3 rounded-md  p-2 text-sm font-semibold leading-6">
                                            <svg class="h-6 w-6 shrink-0" fill="none" viewBox="0 0 24 24"
                                                 stroke-width="1.5" stroke="currentColor" aria-hidden="true">
                                                <path stroke-linecap="round" stroke-linejoin="round"
                                                      d="M2.25 12l8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25"/>
                                            </svg>

                                            {{ $item->label }}
                                        </a>
                                    </li>
                                @endif
                            @endforeach
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>

    <!-- Static sidebar for desktop -->
    <div class="hidden lg:fixed lg:inset-y-0 lg:left-0 lg:z-50 lg:block lg:w-20 lg:overflow-y-auto lg:bg-gray-900 lg:pb-4">
        <nav class="mt-4">
            <ul role="list" class="flex flex-col items-center space-y-1">
                @foreach($navigationItems->filter(fn($n) => $n->getType() === 'item') as $item)
                    <li>
                        <a title="{{ $item->label }}" href="{{ $item->getUrl() }}"
                           class="{{ $item->isActive() ? 'bg-gray-800 text-white' : 'text-gray-400 hover:text-white hover:bg-gray-800' }} group flex gap-x-3 rounded-md p-3 text-sm font-semibold leading-6">
                            @if($item->getIcon())
                                <x-dynamic-component :component="'heroicon-' . $item->getIcon()"
                                                     class="size-6 shrink-0 "/>
                            @endif

                            <span class="sr-only">{{ $item->label }}</span>
                        </a>
                    </li>
                @endforeach
            </ul>
        </nav>
    </div>

    <div class="lg:pl-20">
        <div class="sticky top-0 z-10 flex h-16 shrink-0 items-center gap-x-4 border-b border-gray-200 bg-white px-4 shadow-sm sm:gap-x-6 sm:px-6 lg:px-8">
            <button type="button" class="-m-2.5 p-2.5 text-gray-700 lg:hidden"
                    @click.prevent="offcanvasMenuOpen = !offcanvasMenuOpen">
                <span class="sr-only">{{ __('Open sidebar') }}</span>
                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                     aria-hidden="true">
                    <path stroke-linecap="round" stroke-linejoin="round"
                          d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5"/>
                </svg>
            </button>

            <!-- Separator -->
            <div class="h-6 w-px bg-gray-900/10 lg:hidden" aria-hidden="true"></div>

            <div class="flex flex-1 gap-x-4 self-stretch lg:gap-x-6 justify-between items-center">
                {{--                    <a href="{{ translatedRoute('page') }}" class="text-sm leading-6 text-gray-500 flex items-center">--}}
                {{--                        <svg class="w-4 h-4 mr-1.5" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">--}}
                {{--                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5"></path>--}}
                {{--                        </svg>--}}

                {{--                        {{ __('Back to store') }}--}}
                {{--                    </a>--}}

                <div class="flex items-center gap-x-4 lg:gap-x-6">
                    <!-- Profile dropdown -->
                    <div class="relative" x-data="{ showProfileDropdown: false }">
                        {{--                            <button @click.prevent="showProfileDropdown = !showProfileDropdown" @click.outside="showProfileDropdown = false" type="button" class="-m-1.5 flex items-center p-1.5" id="user-menu-button" aria-expanded="false" aria-haspopup="true">--}}
                        {{--                                <span class="sr-only">{{ __('Open user menu') }}</span>--}}
                        {{--                                <img class="h-8 w-8 rounded-full bg-gray-100" src="{{ auth()->user()->avatar }}" alt="">--}}
                        {{--                                <span class="hidden lg:flex lg:items-center">--}}
                        {{--                                    <span class="ml-4 text-sm font-semibold leading-6 text-gray-900" aria-hidden="true">{{ auth()->user()->fullName }}</span>--}}
                        {{--                                    <svg class="ml-2 h-5 w-5 text-gray-400" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">--}}
                        {{--                                      <path fill-rule="evenodd" d="M5.23 7.21a.75.75 0 011.06.02L10 11.168l3.71-3.938a.75.75 0 111.08 1.04l-4.25 4.5a.75.75 0 01-1.08 0l-4.25-4.5a.75.75 0 01.02-1.06z" clip-rule="evenodd" />--}}
                        {{--                                    </svg>--}}
                        {{--                                </span>--}}
                        {{--                            </button>--}}

                        {{--                            <div--}}
                        {{--                                x-transition:enter="transition ease-out duration-100"--}}
                        {{--                                x-transition:enter-start="transform opacity-0 scale-95"--}}
                        {{--                                x-transition:enter-end="transform opacity-100 scale-100"--}}
                        {{--                                x-transition:leave="transition ease-in duration-75"--}}
                        {{--                                x-transition:leave-start="transform opacity-100 scale-100"--}}
                        {{--                                x-transition:leave-end="transform opacity-0 scale-95"--}}
                        {{--                                x-show="showProfileDropdown"--}}
                        {{--                                x-cloak--}}
                        {{--                                class="absolute right-0 z-10 mt-2.5 w-32 origin-top-right rounded-md bg-white py-2 shadow-lg ring-1 ring-gray-900/5 focus:outline-none" role="menu" aria-orientation="vertical" aria-labelledby="user-menu-button" tabindex="-1">--}}
                        {{--                                <!-- Active: "bg-gray-100", Not Active: "" -->--}}
                        {{--                                <a href="{{ translatedRoute('account.index') }}" class="block px-3 py-1 text-sm leading-6 text-gray-900" role="menuitem" tabindex="-1" id="user-menu-item-0">--}}
                        {{--                                    {{ __('My account') }}--}}
                        {{--                                </a>--}}

                        {{--                                <a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" class="block px-3 py-1 text-sm leading-6 text-gray-900" role="menuitem" tabindex="-1" id="user-menu-item-1">--}}
                        {{--                                    {{ __('Sign out') }}--}}
                        {{--                                </a>--}}
                        {{--                            </div>--}}
                    </div>
                </div>
            </div>
        </div>

        <main class="{{ $navigationItems->filter(fn($n) => $n->isActive() && $n->getChildren()->isNotEmpty())->isNotEmpty() ? 'xl:pl-96' : '' }}">
            <div class="px-4 pt-4 sm:px-6 lg:px-8 lg:py-6">
                @hasSection('mobileNavigation')
                    <div class="lg:hidden">
                        @yield('mobileNavigation')
                    </div>
                @endif

                @yield('content')
            </div>
        </main>
    </div>

    @foreach($navigationItems->filter(fn($n) => $n->isActive() && $n->getChildren()->isNotEmpty()) as $item)
        <aside class="fixed bottom-0 left-20 top-16 hidden w-96 overflow-y-auto bg-gray-100 border-r border-gray-200 px-4 py-6 sm:px-6 lg:px-8 sidebar-{{ $item->key }} {{ $item->isActive() && $item->getChildren()->isNotEmpty() ? 'xl:block' : 'hidden' }}">
            <x-daylight::navigation :items="$item->getChildren()"/>
        </aside>
    @endforeach
</div>
</body>

@auth
    <form id="logout-form" action="/logout" method="POST" class="d-none m-0">
        @csrf
    </form>
@endauth

@daylightScripts
@livewireScriptConfig

</html>
