<x-daylight::tables.table>
    <x-slot:columns>
        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('Name') }}
        </th>

        <th class="p-3 text-left text-sm font-semibold text-gray-900">
            {{ __('Created at') }}
        </th>
    </x-slot:columns>

    @foreach ($this->rows as $row)
        <x-daylight::tables.row wire:key="{{ $row->id }}" :$row>
            <x-daylight::tables.column class="flex items-center">
                <a href="{{ route('daylight.store.brands.edit', $row) }}">
                    {{ $row->name }}
                </a>
            </x-daylight::tables.column>

            <x-daylight::tables.column>
                {{ $row->created_at->isoFormat('LLL') }}
            </x-daylight::tables.column>

            <x-slot:actions>
                <a href="{{ route('daylight.store.brands.edit', $row) }}"
                   class="py-0.5 pl-2 pr-1 inline-flex font-medium items-center gap-1 text-sm">
                    Edit
                </a>
            </x-slot:actions>
        </x-daylight::tables.row>
    @endforeach
</x-daylight::tables.table>
