<div>
    <x-daylight.input.group :label="__('Category')" :error="$errors->first('category')" for="category_id">
        <select multiple wire:model.change="activeCategories">
            @foreach($categories as $category)
                @include('daylight::store.categories.partials.option', ['parent' => $category, 'level' => 0])
            @endforeach
        </select>
    </x-daylight.input.group>

    @foreach($this->generalAttributes() as $attribute)
        <x-daylight.input.group :label="$attribute->translations->first()->name" :error="$errors->first('attribute.' . $attribute->id)" for="attribute-{{ $attribute->id }}">
            <select multiple wire:model.change="activeAttributes.{{ $attribute->id }}">
                @foreach($attribute->values as $value)
                    <flux:select.option value="{{ $value->id }}" wire:key="{{ $value->id }}">
                        {{ $value->translations->first()->name }}
                    </flux:select.option>
                @endforeach
            </select>
        </x-daylight.input.group>
    @endforeach

    @foreach($this->filteredAttributes() as $attribute)
        <x-daylight.input.group :label="$attribute->translations->first()->name" :error="$errors->first('attribute.' . $attribute->id)" for="attribute-{{ $attribute->id }}">
            <select multiple wire:model.change="activeAttributes.{{ $attribute->id }}">
                @foreach($attribute->values as $value)
                    <flux:select.option value="{{ $value->id }}">
                        {{ $value->translations->first()->name }}
                    </flux:select.option>
                @endforeach
            </select>
        </x-daylight.input.group>
    @endforeach

    <div class="hidden">
        @foreach($activeCategories as $category)
            <input type="text" name="categories[]" value="{{ $category }}">
        @endforeach

        @foreach($activeAttributes as $attributeId => $values)
            @foreach($values as $value)
                <input type="text" name="attributes[]" value="{{ $value }}">
            @endforeach
        @endforeach
    </div>
</div>
