@extends('daylight::layouts.app')

@section('title', $user->fullName)

@section('content')
    <x-daylight::page-header :title="$user->fullName">
        @if(auth()->user()->can('update:users') || auth()->user()->can('impersonate:users'))
            <livewire:daylight::user-actions :user="$user" />

            <x-daylight::buttons.primary href="{{ route('daylight.store.customers.edit', $user) }}" element="a">
                {{ __('Edit') }}
            </x-daylight::buttons.primary>
        @endif
    </x-daylight::page-header>

    <x-daylight::session-messages/>

    <x-daylight::input.group :label="__('Name')">
        <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">{{ $user->fullName }}</p>
    </x-daylight::input.group>

    <x-daylight::input.group :label="__('Email')">
        <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">
            {{ $user->email }}

            @if($user->email_verified_at)
               <small class="text-green-400 ml-1">{{ __('Verified at :date', ['date' => $user->email_verified_at->format('d-m-Y H:i')]) }}</small>
            @else
                <small class="text-red-400 ml-1">{{ __('Unverified') }}</small>
            @endif
        </p>
    </x-daylight::input.group>

    <x-daylight::input.group :label="__('Phone')">
        <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">{{ $user->phone ?? __('N/A') }}</p>
    </x-daylight::input.group>

    <x-daylight::input.group :label="__('Customer')">
        <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">
            @if($user->customer)
                <a href="{{ route('daylight.store.customers.show', $user->customer) }}" class="text-sky-700">
                    {{ $user->customer->name }}
                </a>
            @else
                {{ __('N/A') }}
            @endif
        </p>
    </x-daylight::input.group>

    <div class="my-6">
        <h3 class="text-base font-semibold leading-7 text-gray-900 mb-6">{{ __('Orders for this user') }}</h3>
        @if($user->orders_count === 0)
            <p class="block text-sm leading-6 text-gray-700">{{ __('No orders associated with this user.') }}</p>
        @else
            <livewire:daylight::user-order-table :user="$user"/>
        @endif
    </div>
@endsection
