<?php

namespace Daylight\Core\Http\Controllers\Store;

use Daylight\Core\Http\Controllers\Controller;
use Daylight\Core\Models\Order;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;
use Illuminate\View\View;

class OrderController extends Controller implements HasMiddleware
{
    public static function middleware(): array
    {
        return [
            new Middleware('can:create:orders', only: ['create', 'store']),
            new Middleware('can:read:orders', only: ['index', 'show']),
            new Middleware('can:update:orders', only: ['edit', 'update']),
            new Middleware('can:delete:orders', only: ['destroy']),
        ];
    }

    public function index(): View
    {
        return view('daylight::store.orders.index');
    }

    public function show(Order $order)
    {
        $order->loadMissing([
            'customer',
            'user',
            'updates.user',
            'billingAddress.country',
            'shippingAddress.country',
            'items.variant.optionValues.translations',
            'items.variant.optionValues.option.translations',
            'items.variant.product.translations',
            'items.variant.media',
            'items.deliveryAddress',
        ]);

        return view('daylight::store.orders.show', [
            'order' => $order,
        ]);
    }
}
