<?php

namespace Daylight\Core\Livewire\Store;

use Daylight\Core\Livewire\Tables\BaseTable;
use Daylight\Core\Livewire\Tables\Concerns\WithSearch;
use Daylight\Core\Models\Customer;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\View\View;

class CustomerTable extends BaseTable
{
    use WithSearch;

    protected function getBaseQuery(): Builder
    {
        return Customer::query()
            ->withSum('orders', 'total')
            ->withCount('orders')
            ->with('defaultBillingAddress.country')
            ->latest();
    }

    protected function applySearch(Builder $query, ?string $searchQuery): Builder
    {
        return $query->when($searchQuery, function ($query, $searchQuery) {
            $query->where('name', 'like', "%{$searchQuery}%");
        });
    }

    public function render(): View
    {
        return view('daylight::livewire.store.customer-table');
    }
}
