<?php

namespace Daylight\Core\Models;

use Daylight\Core\Models\Translations\AttributeTranslation;
use Daylight\Core\Modules\Multilingualism\Contracts\HasTranslations;
use Daylight\Core\Modules\Multilingualism\Models\Concerns\InteractsWithTranslations;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Attribute extends Model implements HasTranslations
{
    use InteractsWithTranslations;

    protected $guarded = [];

    protected $casts = [
        'filterable' => 'boolean',
    ];

    public function translatedFields(): array
    {
        return ['name'];
    }

    public function categories(): BelongsToMany
    {
        return $this->belongsToMany(Category::class);
    }

    public function values(): HasMany
    {
        return $this->hasMany(AttributeValue::class);
    }

    public function translations(): HasMany
    {
        return $this->hasMany(AttributeTranslation::class);
    }

    public function defaultTranslation(): HasOne
    {
        return $this
            ->hasOne(AttributeTranslation::class)
            ->where('locale', config('multilingualism.default_locale'));
    }
}
