<?php

namespace Daylight\Core\Models;

use Daylight\Core\Models\Translations\AttributeValueTranslation;
use Daylight\Core\Modules\Multilingualism\Contracts\HasTranslations;
use Daylight\Core\Modules\Multilingualism\Models\Concerns\InteractsWithTranslations;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AttributeValue extends Model implements HasTranslations
{
    use InteractsWithTranslations;

    protected $guarded = [];

    public function translatedFields(): array
    {
        return ['name'];
    }

    public function attribute(): BelongsTo
    {
        return $this->belongsTo(Attribute::class);
    }

    public function product(): BelongsToMany
    {
        return $this->belongsToMany(Product::class)->withTimestamps();
    }

    public function translations(): HasMany
    {
        return $this->hasMany(AttributeValueTranslation::class);
    }

    public function defaultTranslation(): HasOne
    {
        return $this
            ->hasOne(AttributeValueTranslation::class)
            ->where('locale', config('multilingualism.default_locale'));
    }
}
