<?php

namespace Daylight\Core\Models\Enums;

enum PaymentMethod: string
{
    case INVOICE = 'invoice';

    case CASH_ON_DELIVERY = 'cash_on_delivery';

    case IDEAL = 'ideal';

    case PAYPAL = 'paypal';

    case BANCONTACT = 'bancontact';

    case VISA = 'visa';

    case MASTERCARD = 'mastercard';

    case MAESTRO = 'maestro';

    case AMERICAN_EXPRESS = 'american_express';

    case SOFORT = 'sofort';

    case BELFIUS = 'belfius';

    case KBC = 'kbc';

    public function label(): string
    {
        return match ($this) {
            self::INVOICE => 'Invoice',
            self::CASH_ON_DELIVERY => 'Cash on Delivery',
            self::IDEAL => 'iDEAL',
            self::PAYPAL => 'PayPal',
            self::BANCONTACT => 'Bancontact',
            self::VISA => 'Visa',
            self::MASTERCARD => 'Mastercard',
            self::MAESTRO => 'Maestro',
            self::AMERICAN_EXPRESS => 'American Express',
            self::SOFORT => 'Sofort',
            self::BELFIUS => 'Belfius',
            self::KBC => 'KBC/CBC',
        };
    }
}
