<?php

namespace Daylight\Core\Modules\Cart\Models;

use App\Models\User;
use Daylight\Core\Models\Variant;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Str;

class Cart extends Model
{
    protected $guarded = [];

    protected $casts = [
        'requires_shipping' => 'bool',
    ];

    public static function booted(): void
    {
        static::creating(function (self $cart) {
            $cart->uuid = (string) Str::uuid();
        });
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function variants(): BelongsToMany
    {
        return $this->belongsToMany(Variant::class)
            ->withPivot('quantity')
            ->withTimestamps()
            ->orderBy('id');
    }
}
