<?php

namespace Daylight\Core\Modules\Multilingualism\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SetLocaleForAuthenticatedUsers
{
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->check()) {
            app()->setLocale(auth()->user()->locale);

            config([
                'multilingualism.locale_prefix' => auth()->user()->locale,
            ]);
        }

        return $next($request);
    }
}
