<?php

namespace Daylight\Core\Modules\Multilingualism\Models\Concerns;

trait InteractsWithTranslations
{
    public function translatedFields(): array
    {
        return [];
    }

    public function __get($key)
    {
        if (in_array($key, $this->translatedFields())) {
            $this->loadMissing([
                'translations' => function ($query) {
                    $query->where('locale', request()->get('locale', app()->getLocale()));
                },
            ]);

            return $this->translations->where('locale', request()->get('locale', app()->getLocale()))->first()->{$key} ?? null;
        }

        return parent::__get($key);
    }
}
