<?php

namespace Daylight\Core\Modules\Multilingualism;

use Daylight\Core\Models\Attribute;
use Daylight\Core\Models\AttributeValue;
use Daylight\Core\Models\Category;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Cache;

class Translations
{
    public static function categories(): Collection
    {
        return Cache::rememberForever('translations.categories', function () {
            return Category::query()
                ->with('translations')
                ->get()
                ->mapWithKeys(function ($category) {
                    return [
                        $category->id => $category->translations->mapWithKeys(function ($translation) {
                            return [
                                $translation->locale => $translation->name,
                            ];
                        }),
                    ];
                });
        });
    }

    public static function attributes(): Collection
    {
        return Cache::rememberForever('translations.attributes', function () {
            return Attribute::query()
                ->with('translations')
                ->get()
                ->mapWithKeys(function ($attribute) {
                    return [
                        $attribute->id => $attribute->translations->mapWithKeys(function ($translation) {
                            return [
                                $translation->locale => $translation->name,
                            ];
                        }),
                    ];
                });
        });
    }

    public static function attributeValues(): Collection
    {
        return Cache::rememberForever('translations.attributeValues', function () {
            return AttributeValue::query()
                ->with('translations')
                ->get()
                ->mapWithKeys(function ($attributeValue) {
                    return [
                        $attributeValue->id => $attributeValue->translations->mapWithKeys(function ($translation) {
                            return [
                                $translation->locale => $translation->name,
                            ];
                        }),
                    ];
                });
        });
    }

    public static function all(): Collection
    {
        return collect([
            'categories' => self::categories(),
            'attributes' => self::attributes(),
            'attributeValues' => self::attributeValues(),
        ]);
    }
}
