<?php

namespace Daylight\Core\Modules\Search\Entities;

use Daylight\Core\Modules\Search\Concerns\InteractsWithQueryString;
use Daylight\Core\Modules\Search\Contracts\Filter;

class ActivePriceFilter implements Filter
{
    use InteractsWithQueryString;

    public string $value;

    public array $originalValues = [];

    public string $deleteUrl;

    public string $group = 'price';

    public function __construct(SearchResult $searchResult, string $key, array $value)
    {
        $this->originalValues = $value;

        $this->value = __('Price between :min - :max', [
            'min' => formatPrice($value['min']),
            'max' => formatPrice($value['max']),
        ]);

        $this->deleteUrl = '?'.$this->getQueryString($searchResult->request->getActiveFilters(), $key);
    }

    public function isCombined(): bool
    {
        return false;
    }
}
