<?php

namespace Daylight\Core\Notifications;

use Daylight\Core\Messages\OrderOverviewMailMessage;
use Daylight\Core\Models\Order;
use Daylight\Core\Settings\General;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Support\HtmlString;

class OrderProcessingNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct(
        public Order $order
    )
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): OrderOverviewMailMessage
    {
        $settings = app(General::class);

        return (new OrderOverviewMailMessage())
            ->subject(__('Order #:orderNumber has been processed', ['orderNumber' => $this->order->number]))
            ->greeting(__('Order #:orderNumber has been processed', ['orderNumber' => $this->order->number]))
            ->line(__('Your order has been processed successfully.'))
            ->renderOrderOverview($this->order)
            ->salutation(
                new HtmlString(
                    __('Kind regards,<br> :companyName', [
                        'companyName' => $settings->name ?? config('app.name')
                    ])
                )
            );
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
