<div>
    @if($media)
        <div>
            <div class="px-0">
                <div class="space-y-1">
                    <h2 class="text-base font-semibold leading-6 text-gray-900">{{ $media->name }}</h2>
                    <p class="text-sm text-gray-500">{{ number_format((int) $media->size / 1024, 0) }} kb</p>
                </div>
            </div>

            <div class="mt-6">
                <div class="w-full h-64 border rounded-lg flex items-center justify-center bg-gray-50">
                    @if($media->isImage())
                        <img class="w-full h-64 object-cover rounded-lg" src="{{ $media->getUrl('raw') }}" alt="{{ $media->name }}">
                    @elseif(str_starts_with($media->type ?? '', 'video/'))
                        <!-- Video Icon -->
                        <svg class="w-24 h-24 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="m15.75 10.5 4.72-4.72a.75.75 0 0 1 1.28.53v11.38a.75.75 0 0 1-1.28.53l-4.72-4.72M4.5 18.75h9a2.25 2.25 0 0 0 2.25-2.25v-9a2.25 2.25 0 0 0-2.25-2.25h-9A2.25 2.25 0 0 0 2.25 7.5v9a2.25 2.25 0 0 0 2.25 2.25Z" />
                        </svg>
                    @elseif($media->type === 'application/pdf')
                        <!-- PDF Icon -->
                        <svg class="w-24 h-24 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19.5 14.25v-2.625a3.375 3.375 0 0 0-3.375-3.375h-1.5A1.125 1.125 0 0 1 13.5 7.125v-1.5a3.375 3.375 0 0 0-3.375-3.375H8.25m2.25 0H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 0 0-9-9Z" />
                        </svg>
                    @elseif(in_array($media->type, ['application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document']))
                        <!-- Word Document Icon -->
                        <svg class="w-24 h-24 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19.5 14.25v-2.625a3.375 3.375 0 0 0-3.375-3.375h-1.5A1.125 1.125 0 0 1 13.5 7.125v-1.5a3.375 3.375 0 0 0-3.375-3.375H8.25m0 12.75h7.5m-7.5 3H12M10.5 2.25H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 0 0-9-9Z" />
                        </svg>
                    @elseif(in_array($media->type, ['application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet']))
                        <!-- Excel Document Icon -->
                        <svg class="w-24 h-24 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3.375 19.5h17.25m-17.25 0a1.125 1.125 0 0 1-1.125-1.125M3.375 19.5h7.5c.621 0 1.125-.504 1.125-1.125m-9.75 0V5.625m0 12.75v-1.5c0-.621.504-1.125 1.125-1.125m18.375 2.625V5.625m0 12.75c0 .621-.504 1.125-1.125 1.125m1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125m0 3.75h-7.5A1.125 1.125 0 0 1 12 18.375m9.75-12.75c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125m19.5 0v1.5c0 .621-.504 1.125-1.125 1.125M2.25 5.625v1.5c0 .621.504 1.125 1.125 1.125m0 0h17.25m-17.25 0h7.5c.621 0 1.125.504 1.125 1.125M3.375 8.25c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125m17.25-3.75h-7.5c-.621 0-1.125.504-1.125 1.125m8.625-1.125c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125m-17.25 0h7.5m-7.5 0c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125M12 10.875v-1.5m0 1.5c0 .621-.504 1.125-1.125 1.125M12 10.875c0 .621.504 1.125 1.125 1.125m-2.25 0c.621 0 1.125.504 1.125 1.125M13.125 12h7.5m-7.5 0c-.621 0-1.125.504-1.125 1.125M20.625 12c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125m-17.25 0h7.5M12 14.625v-1.5m0 1.5c0 .621-.504 1.125-1.125 1.125M12 14.625c0 .621.504 1.125 1.125 1.125m-2.25 0c.621 0 1.125.504 1.125 1.125m0 1.5v-1.5m0 0c0-.621.504-1.125 1.125-1.125m0 0h7.5" />
                        </svg>
                    @else
                        <!-- Generic File Icon -->
                        <svg class="w-24 h-24 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19.5 14.25v-2.625a3.375 3.375 0 0 0-3.375-3.375h-1.5A1.125 1.125 0 0 1 13.5 7.125v-1.5a3.375 3.375 0 0 0-3.375-3.375H8.25m2.25 0H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 0 0-9-9Z" />
                        </svg>
                    @endif
                </div>
            </div>

            <div class="mt-6">
                <h3 class="font-medium text-gray-900">{{ __('daylight::media.information') }}</h3>
                <dl class="mt-2 divide-y divide-gray-200 border-b border-t border-gray-200">
                    <div class="flex justify-between py-3 text-sm font-medium">
                        <dt class="text-gray-500">{{ __('daylight::general.name') }}</dt>
                        <dd class="whitespace-nowrap text-gray-900 max-w-80 truncate">{{ $media->name }}</dd>
                    </div>
                    <div class="flex justify-between py-3 text-sm font-medium">
                        <dt class="text-gray-500">{{ __('daylight::media.created') }}</dt>
                        <dd class="whitespace-nowrap text-gray-900">{{ optional($media->created_at)->format('Y-m-d H:i') }}</dd>
                    </div>
                    <div class="flex justify-between py-3 text-sm font-medium">
                        <dt class="text-gray-500">{{ __('daylight::media.size') }}</dt>
                        <dd class="whitespace-nowrap text-gray-900">{{ number_format((int) $media->size / 1024, 0) }} kb</dd>
                    </div>
                    <div class="flex justify-between py-3 text-sm font-medium">
                        <dt class="text-gray-500">{{ __('daylight::media.mime') }}</dt>
                        <dd class="whitespace-nowrap text-gray-900">{{ $media->type }}</dd>
                    </div>
                    <div class="flex justify-between py-3 text-sm font-medium">
                        <dt class="text-gray-500">URL</dt>
                        <dd class="whitespace-nowrap text-gray-900 max-w-80 truncate">
                            <a href="{{ $media->getUrl() }}" class="text-sky-500" target="_blank">{{ $media->getUrl() }}</a>
                        </dd>
                    </div>
                </dl>
            </div>

            <div class="mt-6 flex justify-end" x-data="{ openConfirm: false }">
                @can('delete:media')
                    <x-daylight::buttons.danger x-on:click.prevent="openConfirm = true">{{ __('daylight::general.delete') }}</x-daylight::buttons.danger>
                @endcan

                <div class="fixed inset-0 z-50 flex items-center justify-center" x-cloak x-show="openConfirm">
                    <div class="absolute inset-0 bg-black/30" x-on:click="openConfirm = false"></div>
                    <div class="bg-white rounded-lg shadow-lg w-full max-w-md relative z-10 p-6">
                        <h3 class="text-lg font-medium mb-4">{{ __('daylight::general.confirm_deletion') }}</h3>
                        <p class="text-sm text-gray-600">{{ __('daylight::media.confirm_delete_file', ['name' => $media->name]) }}</p>
                        <div class="mt-6 flex items-center justify-end gap-3">
                            <x-daylight::buttons.secondary x-on:click.prevent="openConfirm = false">{{ __('daylight::general.cancel') }}</x-daylight::buttons.secondary>
                            <x-daylight::buttons.danger wire:click="deleteFile" x-on:click.prevent="openConfirm = false">{{ __('daylight::general.delete') }}</x-daylight::buttons.danger>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @else
        <div class="p-6 space-y-6 animate-pulse">
            <div class="space-y-2">
                <div class="h-6 bg-gray-200 rounded w-2/3"></div>
                <div class="h-4 bg-gray-200 rounded w-1/3"></div>
            </div>
            <div class="h-64 bg-gray-100 rounded-lg border"></div>
            <div class="space-y-3">
                <div class="h-4 bg-gray-200 rounded w-full"></div>
                <div class="h-4 bg-gray-200 rounded w-5/6"></div>
                <div class="h-4 bg-gray-200 rounded w-2/3"></div>
                <div class="h-4 bg-gray-200 rounded w-1/2"></div>
            </div>
        </div>
    @endif
</div>


