@extends('daylight::layouts.app')

@section('title', __('daylight::settings.create_shipping_class'))

@section('content')
    <x-daylight::page-header :title="__('daylight::settings.create_shipping_class')" />

    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.settings.shipping-classes.store') }}">
        @csrf

        <x-daylight::input.group
            :label="__('daylight::general.name')"
            :error="$errors->first('name')"
            for="code"
        >
            <x-daylight::input.text
                name="name"
                id="name"
                value="{{ old('name') }}"
            />
        </x-daylight::input.group>

        <x-daylight::input.group
            :label="__('daylight::general.default')"
            :error="$errors->first('default')"
            for=""
        >
            <div x-data="{ selected: {{ old('default') ? '1' : '0' }}}">
                <div class="flex items-center mt-1">
                    <button :class="{ 'bg-sky-600': selected, 'bg-gray-200': !selected }"
                            @click.prevent="selected = (selected === 0 ? 1 : 0)" type="button"
                            class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent bg-gray-200 transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-indigo-600 focus:ring-offset-2"
                            role="switch" aria-checked="false" aria-labelledby="annual-billing-label">
                            <span :class="{ 'translate-x-5': selected, 'translate-x-0': !selected }" aria-hidden="true"
                                  class="pointer-events-none inline-block h-5 w-5 translate-x-0 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"></span>
                    </button>
                    <span class="ml-3 text-sm font-medium text-gray-900"
                          id="annual-billing-label">{{ __('daylight::general.default') }}</span>
                </div>

                <input type="hidden" name="default" x-model="selected">
            </div>
        </x-daylight::input.group>

        <div x-data="{ selected: {{ old('taxable') ? '1' : '0' }}}">
            <input type="hidden" name="taxable" x-model="selected">

            <x-daylight::input.group
                    :label="__('daylight::settings.taxable')"
                    :error="$errors->first('taxable')"
                    for=""
            >
                <div class="flex items-center mt-1">
                    <button :class="{ 'bg-sky-600': selected, 'bg-gray-200': !selected }"
                            @click.prevent="selected = (selected === 0 ? 1 : 0)" type="button"
                            class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent bg-gray-200 transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-indigo-600 focus:ring-offset-2"
                            role="switch" aria-checked="false" aria-labelledby="annual-billing-label">
                            <span :class="{ 'translate-x-5': selected, 'translate-x-0': !selected }" aria-hidden="true"
                                  class="pointer-events-none inline-block h-5 w-5 translate-x-0 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"></span>
                    </button>
                    <span class="ml-3 text-sm font-medium text-gray-900"
                          id="annual-billing-label">{{ __('daylight::settings.enableTaxCalculation') }}</span>
                </div>
            </x-daylight::input.group>

            <div x-show="selected">
                <x-daylight::input.group
                        :label="__('daylight::settings.taxClass')"
                        :error="$errors->first('tax_class_id')"
                        for="tax_class_id"
                >
                    <x-daylight::input.select name="tax_class_id" id="tax_class_id">
                        @foreach($taxClasses as $taxClass)
                            <option value="{{ $taxClass->id }}" @if($taxClass->id == old('tax_class_id')) selected @endif>
                                {{ $taxClass->name }}
                            </option>
                        @endforeach
                    </x-daylight::input.select>
                </x-daylight::input.group>
            </div>
        </div>

        <x-daylight::input.group
            :label="__('daylight::general.cumulative')"
            :error="$errors->first('cumulative')"
            for=""
        >
        <div x-data="{ selected: {{ old('cumulative') ? '1' : '0' }}}">
            <div class="flex items-center mt-1">
                <button :class="{ 'bg-sky-600': selected, 'bg-gray-200': !selected }"
                        @click.prevent="selected = (selected === 0 ? 1 : 0)" type="button"
                        class="relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent bg-gray-200 transition-colors duration-200 ease-in-out focus:outline-none focus:ring-2 focus:ring-indigo-600 focus:ring-offset-2"
                        role="switch" aria-checked="false" aria-labelledby="annual-billing-label">
                            <span :class="{ 'translate-x-5': selected, 'translate-x-0': !selected }" aria-hidden="true"
                                  class="pointer-events-none inline-block h-5 w-5 translate-x-0 transform rounded-full bg-white shadow ring-0 transition duration-200 ease-in-out"></span>
                </button>
                <span class="ml-3 text-sm font-medium text-gray-900"
                      id="annual-billing-label">{{ __('daylight::general.cumulative') }}</span>
            </div>

            <input type="hidden" name="cumulative" x-model="selected">
        </div>
        </x-daylight::input.group>

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.settings.shipping-classes.index') }}" element="a">
                {{ __('daylight::general.cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('daylight::general.save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
