<?php

namespace Daylight\Core\Http\Requests\Settings\ShippingClasses;

use Illuminate\Foundation\Http\FormRequest;

class StoreShippingClassRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->can('update:advanced-settings');
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string'],
            'default' => ['required', 'integer', 'between:0,1'],
            'taxable' => ['required', 'integer', 'between:0,1'],
            'tax_class_id' => ['nullable', 'required_if:taxable,1', 'exists:tax_classes,id'],
            'cumulative' => ['required', 'integer', 'between:0,1'],
        ];
    }
}
