<?php

namespace Daylight\Core\Models;

use Daylight\Core\Models\Enums\AddressType;
use Daylight\Core\Models\Enums\CustomerType;
use Daylight\Core\Services\Countries;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Address extends Model
{
    protected $guarded = [];

    protected $casts = [
        'type' => AddressType::class,
        'default' => 'bool',
    ];

    public function customer(): BelongsTo
    {
        return $this->belongsTo(daylightModel('customer'));
    }

    public function country(): BelongsTo
    {
        return $this->belongsTo(daylightModel('country'));
    }

    public function hasExemptedVat(): bool
    {
        if ($this->customer->type === CustomerType::PERSONAL) {
            return false;
        }

        return $this->vat_number && $this->vat_number_verified_at && $this->country_id !== Countries::defaultCountry()->id;
    }
}
