<?php

namespace Daylight\Core\Modules\Search\Entities;

use Daylight\Core\Modules\Search\Concerns\InteractsWithQueryString;

class SortingOption
{
    use InteractsWithQueryString;

    public string $url;

    public bool $active = false;

    public function __construct(SearchResult $searchResult, string $key, public string $value)
    {
        $this->active = isset($searchResult->request->getSortBy()[0]) && $searchResult->request->getSortBy()[0] === $key;
        $this->url = '?' . $this->getQueryString($searchResult->request->getActiveFilters(), sortBy: $key);
    }
}
