# Daylight Core
## E-commerce core base package

### Installeer Daylight
Installeer daylight, diverse functies worden geregistreerd en aangemaakt. Tevens worden migrations en seeder uitgevoerd.
```bash
php artisan daylight:install
```

### Config-gedreven Model Binding
Vanaf nu gebruikt de core `config/daylight.php` om alle models te resolven. Hierdoor kun je in je project eigen models laten gebruiken zonder de core te wijzigen.

- Stel je eigen models in via `config/daylight.php` onder `models`.
- Route model binding wordt automatisch gezet op basis van de keys in `daylight.models` (bijv. `product`, `variant`, `shipping_class`). Hierdoor resolve `products/{product}` naar jouw eigen model.
- Interne relaties en queries gebruiken helper `daylightModel($key)` zodat alle Eloquent-relaties en statische aanroepen ook jouw override gebruiken.

Voorbeeld config:
```php
return [
    'models' => [
        'product' => App\Models\Product::class,
        'variant' => App\Models\Variant::class,
        // ...
    ],
];
```

### Scout indexing met overrides
De core levert twee Artisan commands die Laravel Scout indexing laten draaien tegen de models uit `config('daylight.models.*')`.

Importeren (één model of alles):
```bash
php artisan daylight:scout:import product
php artisan daylight:scout:import --all
```

Flushen (één model of alles):
```bash
php artisan daylight:scout:flush product
php artisan daylight:scout:flush --all
```

Opmerkingen:
- Je kunt als argument óf de config key (bijv. `product`) óf een FQCN doorgeven.
- Alleen models met Laravel Scout's `Searchable` trait worden geïndexeerd/geflaushed.

### Code style met Laravel Pint
We gebruiken [Laravel Pint](https://laravel.com/docs/12.x/pint) voor consistente code style.

Installatie (automatisch via composer require-dev):
```bash
composer install
```

Handige scripts:
```bash
composer lint          # Fix style issues
composer lint:test     # Check alleen, geen wijzigingen
composer lint:parallel # Sneller fixen in parallel
```

Eigen regels kun je aanpassen in `pint.json`.