<div class="grid lg:grid-cols-3 gap-4">
        <div class="flex items-center text-sm gap-4">
            @if($this->currentDirectory)
                <div class="flex items-center">
                    @if($this->currentDirectory->parent_id)
                        <button type="button" wire:click="goUp">
                            <svg class="w-4 h-4" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                            </svg>
                        </button>
                    @else
                        <button type="button" wire:click="goRoot">
                            <svg class="w-4 h-4" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                            </svg>
                        </button>
                    @endif
                </div>
            @endif

            <h1 class="text-xl leading-loose font-medium">{{ $this->currentDirectory?->name ?? __('daylight::media.media') }}</h1>
        </div>

    <div class="flex items-center lg:justify-end text-sm gap-4 col-span-2">
        <div class="relative flex-1 lg:flex-initial lg:w-64">
            <input
                type="text"
                wire:model.live.debounce.300ms="search"
                placeholder="{{ __('daylight::media.search_files') }}"
                class="block w-full rounded-md border-gray-300 pl-10 text-sm focus:border-sky-500 focus:ring-sky-500"
            >
            <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                </svg>
            </div>
        </div>

        @if($this->currentDirectory)
            <button type="button" class="inline-flex items-center justify-center rounded-md border border-gray-300 bg-white p-2 text-gray-600 hover:bg-gray-50 hover:text-gray-700 focus:outline-none focus:ring-2 focus:ring-sky-500 focus:ring-offset-2"
                    x-on:click.prevent="$dispatch('open-directory-info', { id: {{ $this->currentDirectory->id }} })">
                <svg class="w-5 h-5" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9.594 3.94c.09-.542.56-.94 1.11-.94h2.593c.55 0 1.02.398 1.11.94l.213 1.281c.063.374.313.686.645.87.074.04.147.083.22.127.325.196.72.257 1.075.124l1.217-.456a1.125 1.125 0 0 1 1.37.49l1.296 2.247a1.125 1.125 0 0 1-.26 1.431l-1.003.827c-.293.241-.438.613-.43.992a7.723 7.723 0 0 1 0 .255c-.008.378.137.75.43.991l1.004.827c.424.35.534.955.26 1.43l-1.298 2.247a1.125 1.125 0 0 1-1.369.491l-1.217-.456c-.355-.133-.75-.072-1.076.124a6.47 6.47 0 0 1-.22.128c-.331.183-.581.495-.644.869l-.213 1.281c-.09.543-.56.94-1.11.94h-2.594c-.55 0-1.019-.398-1.11-.94l-.213-1.281c-.062-.374-.312-.686-.644-.87a6.52 6.52 0 0 1-.22-.127c-.325-.196-.72-.257-1.076-.124l-1.217.456a1.125 1.125 0 0 1-1.369-.49l-1.297-2.247a1.125 1.125 0 0 1 .26-1.431l1.004-.827c.292-.24.437-.613.43-.991a6.932 6.932 0 0 1 0-.255c.007-.38-.138-.751-.43-.992l-1.004-.827a1.125 1.125 0 0 1-.26-1.43l1.297-2.247a1.125 1.125 0 0 1 1.37-.491l1.216.456c.356.133.751.072 1.076-.124.072-.044.146-.086.22-.128.332-.183.582-.495.644-.869l.214-1.28Z"></path>
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"></path>
                </svg>
            </button>
        @endif

        @can('create:media')
            <x-daylight::buttons.secondary x-on:click.prevent="$dispatch('toggle-create-directory-modal')">
                {{ __('daylight::media.create_directory') }}
            </x-daylight::buttons.secondary>
        @endcan

            @can('create:media')
                <x-daylight::buttons.primary type="button" x-on:click.prevent="$dispatch('open-upload-modal')">{{ __('daylight::media.upload_files') }}</x-daylight::buttons.primary>
            @endcan
    </div>
</div>


