@extends('daylight::layouts.app')

@section('title', __('daylight::settings.create_tax_class'))

@section('content')
    <x-daylight::page-header :title="__('daylight::settings.create_tax_class')" />

    <x-daylight::session-messages/>

    <form method="post" action="{{ route('daylight.settings.tax-classes.store') }}">
        @csrf

        <x-daylight::input.group
            :label="__('daylight::general.name')"
            :error="$errors->first('name')"
            for="code"
        >
            <x-daylight::input.text
                name="name"
                id="name"
                value="{{ old('name') }}"
            />
        </x-daylight::input.group>

        <div class="mt-6 flex items-center justify-end gap-x-3">
            <x-daylight::buttons.secondary href="{{ route('daylight.settings.tax-classes.index') }}" element="a">
                {{ __('daylight::general.cancel') }}
            </x-daylight::buttons.secondary>

            <x-daylight::buttons.primary type="submit">
                {{ __('daylight::general.save') }}
            </x-daylight::buttons.primary>
        </div>
    </form>
@endsection
