<?php

namespace Daylight\Core\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OrderUpdate extends Model
{
    protected $guarded = [];

    public function order(): BelongsTo
    {
        return $this->belongsTo(daylightModel('order'));
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
