<template x-teleport="body">
    <div 
        x-show="showOptionValueSlideOver"
        class="relative z-30"
        style="display: none;"
    >
        <!-- Backdrop -->
        <div
            x-show="showOptionValueSlideOver"
            x-transition:enter="transition-opacity ease-linear duration-300"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="transition-opacity ease-linear duration-300"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
            @click="closeOpenValueSlideOver"
            class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity z-40"
        ></div>

        <!-- Panel -->
        <div class="fixed inset-0 overflow-hidden z-50" @click.self="closeOpenValueSlideOver">
            <div class="absolute inset-0 overflow-hidden" @click.self="closeOpenValueSlideOver">
                <div class="pointer-events-none fixed inset-y-0 right-0 flex max-w-full pl-10" @click.self="closeOpenValueSlideOver">
                    <div
                        x-show="showOptionValueSlideOver"
                        x-transition:enter="transform transition ease-in-out duration-500 sm:duration-700"
                        x-transition:enter-start="translate-x-full"
                        x-transition:enter-end="translate-x-0"
                        x-transition:leave="transform transition ease-in-out duration-500 sm:duration-700"
                        x-transition:leave-start="translate-x-0"
                        x-transition:leave-end="translate-x-full"
                        class="pointer-events-auto w-screen max-w-2xl"
                    >
                <form
                    x-data='{
                        optionValue: {
                            id: null,
                            color: null,
                            order: null,
                            translations: @json(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales()->mapWithKeys(function($locale) { return [$locale => ['name' => '']]; })),
                        }
                    }'
                    x-modelable="optionValue"
                    x-model="currentOptionValue"
                    @submit.prevent="$dispatch('save-option-value')"
                    class="h-full"
                >
                    <div class="flex h-full flex-col overflow-y-scroll bg-white shadow-xl">
                        <div class="flex-1">
                            <div class="bg-sky-600 px-4 py-6 sm:px-6">
                                <div class="flex items-start justify-between space-x-3">
                                    <div class="space-y-1">
                                        <h2 class="text-base font-semibold leading-6 text-white" id="slide-over-title">{{ __('daylight::store.product_option') }}</h2>
                                        <p class="text-sm text-white text-opacity-75">{{ __('daylight::store.add_options_message') }}</p>
                                    </div>

                                    <div class="flex h-7 items-center">
                                        <button @click.prevent="closeOpenValueSlideOver" type="button" class="relative text-gray-400 hover:text-gray-500">
                                            <span class="absolute -inset-2.5"></span>
                                            <span class="sr-only">{{ __('daylight::general.close_panel') }}</span>
                                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <div class="space-y-6 py-6 sm:space-y-0 sm:divide-y sm:divide-gray-200 sm:py-0">
                                @foreach(\Daylight\Core\Modules\Multilingualism\Multilingualism::getAvailableLocales() as $locale)
                                    <div
                                        class="space-y-2 px-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:space-y-0 sm:px-6 sm:py-5">
                                        <div>
                                            <label for="name" class="text-sm font-medium leading-6 text-gray-900 sm:mt-1.5 flex items-center">
                                                {{ __('daylight::general.name_locale', ['locale' => 'NL' ]) }}
                                            </label>
                                        </div>
                                        <div class="sm:col-span-2">
                                            <input x-model="optionValue.translations['{{ $locale }}'].name" type="text" id="name" class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 focus:ring-2 focus:ring-inset focus:ring-indigo-600 sm:text-sm sm:leading-6">
                                        </div>
                                    </div>
                                @endforeach

                                <div
                                    class="space-y-2 px-4 sm:grid sm:grid-cols-3 sm:gap-4 sm:space-y-0 sm:px-6 sm:py-5">
                                    <div>
                                        <label for="optionType" class="text-sm font-medium leading-6 text-gray-900 sm:mt-1.5 flex items-center">
                                            {{ __('daylight::general.color') }}
                                        </label>
                                    </div>
                                    <div class="sm:col-span-2">
                                        <input x-model="optionValue.color" type="color" id="color" class="block w-full rounded-md border-0 py-1.5 text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 placeholder:text-gray-400 focus:ring-2 focus:ring-inset focus:ring-indigo-600 sm:text-sm sm:leading-6">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Action buttons -->
                        <div class="flex-shrink-0 border-t border-gray-200 px-4 py-5 sm:px-6">
                            <div class="flex justify-end space-x-3">
                                <button type="button" @click.prevent="closeOpenValueSlideOver" class="bg-white text-sky-600 hover:opacity-75 border-sky-600 py-2.5 px-4 border rounded-md text-sm leading-5 font-medium focus:outline-none focus:border-blue-300 focus:shadow-outline-blue transition duration-150 ease-in-out">
                                    {{ __('daylight::general.cancel') }}
                                </button>

                                <button type="submit"
                                        class="bg-sky-600 text-white hover:bg-sky-700 border-sky-600 text-sm py-2.5 px-4 border rounded-md leading-5 font-medium focus:outline-none focus:border-blue-300 focus:shadow-outline-blue transition duration-150 ease-in-out">
                                    {{ __('daylight::general.save') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
                </div>
            </div>
        </div>
    </div>
</template>
