<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('last_name')->after('name')->nullable();
            $table->string('phone')->after('email_verified_at')->nullable();
            $table->string('locale')->after('phone')->default('en');
            $table->string('invite_token')->after('remember_token')->nullable();
            $table->dateTime('invite_send_at')->after('invite_token')->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['last_name', 'phone', 'locale', 'invite_token', 'invite_send_at']);
        });
    }
};
