<?php

namespace Daylight\Core\Database\Seeders;

use Daylight\Core\Models\Page;
use Daylight\Core\Modules\Multilingualism\Multilingualism;
use Illuminate\Database\Seeder;

class PageSeeder extends Seeder
{
    public function run(): void
    {
        $pages = [
            'Home',
            'About us',
        ];

        foreach ($pages as $pageName) {
            $page = Page::create();

            Multilingualism::getAvailableLocales()->each(function ($locale) use ($page, $pageName) {
                $page->translations()->create([
                    'locale' => $locale,
                    'name' => $pageName,
                ]);
            });
        }
    }
}
