@extends('daylight::layouts.app')

@section('title', $customer->name)

@section('content')
    <x-daylight::page-header :title="$customer->name">
        @can('update:customers')
            <x-daylight::buttons.primary href="{{ route('daylight.store.customers.edit', $customer) }}" element="a">
                {{ __('daylight::general.edit') }}
            </x-daylight::buttons.primary>
        @endcan
    </x-daylight::page-header>

    <x-daylight::session-messages/>


    <x-daylight::input.group :label="__('daylight::general.customer_type')">
        <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">{{ $customer->type->label() }}</p>
    </x-daylight::input.group>
    <x-daylight::input.group :label="__('daylight::general.entity_name')">
        <p class="block text-sm leading-6 text-gray-700 sm:pt-1.5">{{ $customer->name }}</p>
    </x-daylight::input.group>

    <x-daylight::input.group :label="__('daylight::general.default_billing_address')">
        <div class="block text-sm leading-6 text-gray-700 sm:pt-1.5">
            @if($customer->defaultBillingAddress)
                <x-daylight::address :address="$customer->defaultBillingAddress"/>
            @else
                <p class="block text-sm leading-6 text-gray-700">{{ __('daylight::general.no_default_billing_address') }}</p>
            @endif
        </div>
    </x-daylight::input.group>

    <x-daylight::input.group :label="__('daylight::general.other_addresses')">
        <div class="grid grid-cols-4 gap-4">
            @forelse($customer->addresses as $address)
                <div class="border p-4 block text-sm leading-6 text-gray-700">
                    <x-daylight::address :address="$address"/>
                </div>
            @empty
                <p class="block text-sm leading-6 text-gray-700 pt-1.5">{{ __('daylight::general.no_addresses_found') }}</p>
            @endforelse
        </div>
    </x-daylight::input.group>

    <div class="my-6">
        <h3 class="text-base font-semibold leading-7 text-gray-900 mb-6">{{ __('daylight::general.users_associated') }}</h3>

        @if($customer->users_count === 0)
            <p class="block text-sm leading-6 text-gray-700">{{ __('daylight::general.no_users_associated') }}</p>
        @else
            <livewire:daylight::customer-user-table :customer="$customer"/>
        @endif
    </div>

    <div class="my-6">
        <h3 class="text-base font-semibold leading-7 text-gray-900 mb-6">{{ __('daylight::general.orders_for_customer') }}</h3>
        @if($customer->orders_count === 0)
            <p class="block text-sm leading-6 text-gray-700">{{ __('daylight::general.no_orders_associated') }}</p>
        @else
            <livewire:daylight::customer-order-table :customer="$customer"/>
        @endif
    </div>
@endsection
