<?php

namespace Daylight\Core\Livewire\Store;

use Daylight\Core\Livewire\Tables\BaseTable;
use Daylight\Core\Livewire\Tables\Concerns\WithSearch;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\View\View;

class BrandTable extends BaseTable
{
    use WithSearch;

    protected function getBaseQuery(): Builder
    {
        return (daylightModel('brand'))::query();
    }

    protected function applySearch(Builder $query, ?string $searchQuery): Builder
    {
        return $query->when($searchQuery, function ($query, $searchQuery) {
            $query->where('name', 'like', "%{$searchQuery}%");
        });
    }

    public function render(): View
    {
        return view('daylight::livewire.store.brand-table');
    }
}
