<?php

namespace Daylight\Core\Modules\Payment\Events\Status;

use Daylight\Core\Modules\Payment\Events\Contracts\PaymentStatusUpdated;
use Daylight\Core\Models\Order;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class AwaitingPayment implements PaymentStatusUpdated
{

    use Dispatchable, SerializesModels;

    public function __construct(
        public Order $order
    )
    {
        //
    }

    public function getOrder(): Order
    {
        return $this->order;
    }


}