<?php

namespace Daylight\Core\Modules\Payment\Providers;

use Daylight\Core\Modules\Payment\Events\Status\AwaitingPayment;
use Daylight\Core\Modules\Payment\Events\Status\PaymentFailed;
use Daylight\Core\Modules\Payment\Events\Status\PaymentSucceeded;
use Daylight\Core\Modules\Payment\Events\WebhookReceived;
use Daylight\Core\Modules\Payment\Listeners\UpdatePaymentStatus;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{

    protected $listen = [
        WebhookReceived::class => [
            UpdatePaymentStatus::class,
        ],

        PaymentSucceeded::class => [

        ],

        PaymentFailed::class => [

        ],

        AwaitingPayment::class => [

        ],
    ];

}
