@props([
    'directories' => collect(),
])

@if($directories->count() > 0)
    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 xl:grid-cols-8 2xl:grid-cols-10 gap-6 mt-2">
        @foreach($directories as $directory)
            <button
                type="button"
                class="bg-gray-100 hover:bg-gray-200 border-gray-300 w-full flex flex-col items-center justify-center py-6 px-3 aspect-square rounded-lg"
                wire:click="changeCurrentDirectory({{ $directory->id }})"
            >
                <svg class="w-10 h-10 text-gray-400 mb-4" data-slot="icon" fill="none" stroke-width="1.5" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 12.75V12A2.25 2.25 0 0 1 4.5 9.75h15A2.25 2.25 0 0 1 21.75 12v.75m-8.69-6.44-2.12-2.12a1.5 1.5 0 0 0-1.061-.44H4.5A2.25 2.25 0 0 0 2.25 6v12a2.25 2.25 0 0 0 2.25 2.25h15A2.25 2.25 0 0 0 21.75 18V9a2.25 2.25 0 0 0-2.25-2.25h-5.379a1.5 1.5 0 0 1-1.06-.44Z"></path>
                </svg>
                <div class="truncate whitespace-nowrap w-full text-gray-600 text-sm">{{ $directory->name }}</div>
            </button>
        @endforeach
    </div>
@endif


