@props([
    'parent',
    'level' => 0,
    'selected' => false,
])
<option value="{{ $parent->id }}" {{ $selected ? 'selected' : '' }}>
    {{ $level ? str_repeat('—', $level) . ' ' : '' }} {{ $parent->translations->first()->name ?? __('daylight::general.not_translated') . ' (' . $parent->id . ')' }}
</option>

@if($parent->children->isNotEmpty())
    @foreach($parent->children as $child)
        @include('daylight::store.categories.partials.option', ['parent' => $child, 'level' => $level + 1])
    @endforeach
@endif
