<?php

namespace Daylight\Core\Modules\Cart;

use Daylight\Core\Modules\Cart\Contracts\CalculatesShippingCosts;
use Daylight\Core\Modules\Cart\Contracts\CartInterface;
use Daylight\Core\Modules\Cart\Http\Middleware\EnsureCartSessionCreated;
use Illuminate\Routing\Router;
use Illuminate\Support\ServiceProvider;

class CartServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->singleton(CartInterface::class, function () {
            return new Cart(
                sessionManager: session(),
            );
        });

        $this->app->singleton(CalculatesShippingCosts::class, function () {
            return new ShippingCostCalculator(
                cart: $this->app->make(CartInterface::class),
            );
        });

        app(Router::class)->aliasMiddleware('cart', EnsureCartSessionCreated::class);
    }
}
