<?php

namespace Daylight\Core\Modules\MediaLibrary;

use Daylight\Core\Modules\Admin\Entities\Page;
use Daylight\Core\Modules\Admin\Registries\NavigationRegistry;
use Daylight\Core\Modules\MediaLibrary\Console\Commands\RegenerateConversionsCommand;
use Daylight\Core\Modules\MediaLibrary\Livewire\DirectoryHeader;
use Daylight\Core\Modules\MediaLibrary\Livewire\DirectoryInfo;
use Daylight\Core\Modules\MediaLibrary\Livewire\DirectoryList;
use Daylight\Core\Modules\MediaLibrary\Livewire\FileGrid;
use Daylight\Core\Modules\MediaLibrary\Livewire\FileInfo;
use Daylight\Core\Modules\MediaLibrary\Livewire\FileItem;
use Daylight\Core\Modules\MediaLibrary\Livewire\MediaLibrary;
use Daylight\Core\Modules\MediaLibrary\Livewire\MediaSelector;
use Daylight\Core\Modules\MediaLibrary\Livewire\MediaUploader;
use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

class MediaLibraryServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../../config/media.php', 'media'
        );
    }

    public function boot(): void
    {
        app(NavigationRegistry::class)->register([
            Page::create()
                ->setOrder(100)
                ->setKey('media-library')
                ->setLabel('daylight::media.media_library')
                ->setPermission('view:administration')
                ->setIcon('o-photo')
                ->setRoute('daylight.media.index'),
        ]);

        $this->registerLivewireComponents();
        $this->registerCommands();
    }

    public function registerLivewireComponents(): self
    {
        if (! class_exists(Livewire::class)) {
            return $this;
        }

        Livewire::component('daylight::media-library', MediaLibrary::class);
        Livewire::component('daylight::media-selector', MediaSelector::class);
        Livewire::component('daylight::media-uploader', MediaUploader::class);
        Livewire::component('daylight::media-directory-header', DirectoryHeader::class);
        Livewire::component('daylight::media-directory-list', DirectoryList::class);
        Livewire::component('daylight::media-file-grid', FileGrid::class);
        Livewire::component('daylight::media-file-item', FileItem::class);
        Livewire::component('daylight::media-file-info', FileInfo::class);
        Livewire::component('daylight::media-directory-info', DirectoryInfo::class);

        return $this;
    }

    public function registerCommands(): self
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                RegenerateConversionsCommand::class,
            ]);
        }

        return $this;
    }
}
