<?php

namespace Daylight\Mollie\Builders;

use Daylight\Core\Models\Order;
use Daylight\Core\Modules\Payment\Contracts\PaymentBuilder as PaymentBuilderContract;
use Daylight\Core\Modules\Payment\Contracts\ProvidesPaymentMethods;
use Daylight\Core\Modules\Payment\Entities\PaymentIntent;
use Mollie\Laravel\Facades\Mollie;

class PaymentBuilder implements PaymentBuilderContract
{
    public Order $order;

    public ?string $paymentMethod = null;

    public bool $preferredPaymentMethod = true;

    public function __construct()
    {
        //
    }

    public function forOrder(Order $order): self
    {
        $this->order = $order;

        return $this;
    }

    public function withoutPreferredPaymentMethod(): self
    {
        $this->preferredPaymentMethod = false;

        return $this;
    }

    public function setPaymentMethod(string $paymentMethod): self
    {
        $this->paymentMethod = $paymentMethod;

        return $this;
    }

    public function create(): PaymentIntent
    {
        $paymentMethod = app(ProvidesPaymentMethods::class)->getById($this->paymentMethod);

        $payment = Mollie::api()->payments->create(array_filter([
            'amount' => [
                'currency' => 'EUR',
                'value' => number_format($this->order->total, 2, '.', ''),
            ],
            'method' => $paymentMethod?->getGatewayKey(),
            'description' => 'Order #' . $this->order->number,
            'redirectUrl' => translatedRoute('checkout.status', ['orderUuid' => $this->order->uuid]),
            'cancelUrl' => translatedRoute('checkout.status', ['orderUuid' => $this->order->uuid]),
            'webhookUrl' => route('mollie.webhook'),
            'metadata' => [
                'order_id' => $this->order->id,
            ],
        ]));

        return new PaymentIntent(
            order: $this->order,
            transactionId: $payment->id,
            status: 'open',
            redirectUrl: $payment->getCheckoutUrl(),
        );
    }

    public function cancel(): bool
    {
        // @todo: Cancel transaction

        return true;
    }
}
