<?php

namespace Daylight\Mollie\Builders;

use Daylight\Core\Models\Order;
use Daylight\Core\Modules\Payment\Contracts\PaymentStatusBuilder as PaymentStatusBuilderContract;
use Daylight\Core\Modules\Payment\Entities\PaymentStatus;
use Daylight\Core\Modules\Payment\Enums\PaymentStatus as PaymentStatusEnum;
use Mollie\Laravel\Facades\Mollie;

class PaymentStatusBuilder implements PaymentStatusBuilderContract
{
    public Order $order;

    public function get(): PaymentStatus
    {
        $payment = Mollie::api()->payments->get($this->order->payment_gateway_id);

        return new PaymentStatus(
            transactionId: $payment->id,
            status: $payment->status,
            formattedStatus: $this->getFormattedStatus($payment->status)
        );
    }

    public function forOrder(Order $order): PaymentStatusBuilderContract
    {
        $this->order = $order;

        return $this;
    }

    private function getFormattedStatus(string $status): PaymentStatusEnum
    {
        return PaymentStatusEnum::from($status);
    }
}
