<?php

namespace Daylight\Mollie;

use Daylight\Core\Modules\Payment\Contracts\ProvidesPaymentMethods;
use Daylight\Core\Modules\Payment\PaymentMethod;
use Daylight\Mollie\PaymentMethods\Bancontact;
use Daylight\Mollie\PaymentMethods\Ideal;
use Illuminate\Support\Collection;

class PaymentMethods implements ProvidesPaymentMethods
{
    public function get(): Collection
    {
        return collect([
            Ideal::class,
            //            CreditCard::class,
            //            PayPal::class,
            Bancontact::class,
            //            EPS::class,
            //            Przelewy24::class,
        ])->map(function ($class) {
            return new $class;
        })->sortBy(function ($method) {
            return $method->order();
        });
    }

    public function getById(?string $id): ?PaymentMethod
    {
        if(is_null($id)) {
            return null;
        }

        return $this->get()->filter(function ($method) use ($id) {
            return $method->getId() === $id;
        })->first();
    }
}
